/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.components;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.jobs.model.Profession;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class ProfessionsComponent
implements EntityComponent {
    private static final float MINIMUM_SKILL_FOR_PROFESSION = 0.3f;
    Map<Profession, Float> professionToAbilityLevelMap = new HashMap<Profession, Float>();
    List<QuantifiedProfession> quantifiedProfessions = new ArrayList<QuantifiedProfession>();

    public ProfessionsComponent() {
        this.quantifiedProfessions.add(new QuantifiedProfession(ProfessionDictionary.NULL_PROFESSION, 0.0f));
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        ProfessionsComponent cloned = new ProfessionsComponent();
        for (Map.Entry<Profession, Float> entry : this.professionToAbilityLevelMap.entrySet()) {
            cloned.professionToAbilityLevelMap.put(entry.getKey(), entry.getValue());
        }
        for (QuantifiedProfession quantifiedProfession : this.quantifiedProfessions) {
            cloned.quantifiedProfessions.add(quantifiedProfession.clone());
        }
        return cloned;
    }

    public void add(Profession profession, float skillLevel) {
        QuantifiedProfession quantifiedProfession = new QuantifiedProfession(profession, skillLevel);
        this.quantifiedProfessions.add(quantifiedProfession);
        this.skillLevelsUpdated();
    }

    public Profession getPrimaryProfession(Profession defaultProfession) {
        if (this.quantifiedProfessions.isEmpty()) {
            return defaultProfession;
        }
        QuantifiedProfession quantifiedProfession = this.quantifiedProfessions.get(0);
        if (quantifiedProfession.getSkillLevel() > 0.3f) {
            return quantifiedProfession.getProfession();
        }
        return defaultProfession;
    }

    private void skillLevelsUpdated() {
        this.quantifiedProfessions.sort((o1, o2) -> (int)(((QuantifiedProfession)o2).skillLevel * 10000.0f - ((QuantifiedProfession)o1).skillLevel * 10000.0f));
        this.professionToAbilityLevelMap.clear();
        for (QuantifiedProfession quantifiedProfession : this.quantifiedProfessions) {
            this.professionToAbilityLevelMap.put(quantifiedProfession.profession, Float.valueOf(quantifiedProfession.skillLevel));
        }
    }

    public List<QuantifiedProfession> getByPriority() {
        return this.quantifiedProfessions;
    }

    public boolean hasProfession(Profession profession) {
        return this.professionToAbilityLevelMap.containsKey(profession);
    }

    public float getSkillLevel(Profession profession) {
        Float skillLevel = this.professionToAbilityLevelMap.get(profession);
        if (skillLevel == null || skillLevel.floatValue() <= 0.0f) {
            return 0.2f;
        }
        return skillLevel.floatValue();
    }

    public static class QuantifiedProfession {
        private final Profession profession;
        private float skillLevel;

        public QuantifiedProfession(Profession profession, float skillLevel) {
            this.profession = profession;
            this.skillLevel = skillLevel;
        }

        public QuantifiedProfession clone() {
            return new QuantifiedProfession(this.profession, this.skillLevel);
        }

        public Profession getProfession() {
            return this.profession;
        }

        public float getSkillLevel() {
            return this.skillLevel;
        }
    }
}

